<?php
/**
 * Front page template
 * 
 * @package Elite_Realty
 */

get_header();

// Get hero background image
$hero_bg = get_theme_mod( 'hero_background_image' );
if ( ! $hero_bg ) {
    // Fallback to default image
    $hero_bg = 'https://readdy.ai/api/search-image?query=luxury%20modern%20colonial%20house%20in%20northeastern%20united%20states%20with%20beautiful%20landscaping%2C%20autumn%20foliage%2C%20stone%20pathway%20leading%20to%20elegant%20front%20entrance%2C%20professional%20real%20estate%20photography%2C%20warm%20golden%20hour%20lighting%2C%20pristine%20manicured%20lawn%2C%20mature%20trees%2C%20upscale%20neighborhood%20setting%2C%20architectural%20excellence&width=1920&height=1080&seq=hero001&orientation=landscape';
}
?>

<style>
.hero-bg {
    background-image: linear-gradient(rgba(0, 0, 0, 0.4), rgba(0, 0, 0, 0.3)), url('<?php echo esc_url( $hero_bg ); ?>');
}
</style>

<!-- Hero Section -->
<section class="hero-bg min-h-screen flex items-center justify-center relative">
    <div class="w-full max-w-4xl mx-auto px-6 text-center text-white">
        <h1 class="text-5xl md:text-7xl font-bold mb-6 leading-tight">
            <?php echo esc_html( get_theme_mod( 'hero_title', 'Find Your Dream Home in the Northeast' ) ); ?>
        </h1>
        <p class="text-xl md:text-2xl mb-12 opacity-90">
            <?php echo esc_html( get_theme_mod( 'hero_subtitle', 'Discover luxury properties in New England\'s most prestigious neighborhoods' ) ); ?>
        </p>
        <div class="relative">
            <div class="flex mb-0">
                <button class="px-8 py-3 bg-white text-gray-900 font-semibold rounded-t-2xl border-t border-l border-r border-gray-200 shadow-sm relative z-10 -mb-[1px]">Buy</button>
                <a href="<?php echo esc_url( home_url( '/home-valuation' ) ); ?>" class="px-8 py-3 bg-gray-50 text-gray-600 font-semibold rounded-t-2xl border-t border-l border-r border-gray-200 hover:bg-gray-100 transition-colors -mb-[1px] ml-1">Sell</a>
            </div>
            <div class="bg-white rounded-2xl p-6 shadow-2xl">
                <div class="relative">
                    <input type="text" placeholder="Enter address, neighborhood, city, or ZIP code" class="w-full px-4 py-3 pr-24 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary text-gray-800 text-sm">
                    <div class="absolute right-12 top-1/2 transform -translate-y-1/2 w-5 h-5 flex items-center justify-center">
                        <i class="ri-map-pin-line text-gray-400"></i>
                    </div>
                    <button class="absolute right-3 top-1/2 transform -translate-y-1/2 w-8 h-8 flex items-center justify-center bg-primary text-white rounded-full hover:bg-blue-700 transition-colors">
                        <i class="ri-search-line"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 text-white scroll-indicator">
        <div class="w-6 h-6 flex items-center justify-center">
            <i class="ri-arrow-down-line ri-lg"></i>
        </div>
    </div>
</section>

<!-- Featured Properties Section -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-6">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-gray-900 mb-4">Featured Properties</h2>
            <p class="text-xl text-gray-600">Handpicked luxury homes in prime Northeast locations</p>
        </div>
        <div class="slider-container relative">
            <div class="slider-track flex transition-transform duration-500 ease-in-out" id="propertySlider">
                <?php
                // Query featured properties
                $args = array(
                    'post_type' => 'property',
                    'posts_per_page' => 6,
                    'meta_value' => 'yes',
                    'orderby' => 'date',
                    'order' => 'DESC'
                );
                
                $properties = new WP_Query( $args );
                
                if ( $properties->have_posts() ) :
                    while ( $properties->have_posts() ) : $properties->the_post();
                        $price = get_post_meta( get_the_ID(), 'price', true );
                        $bedrooms = get_post_meta( get_the_ID(), 'bedrooms', true );
                        $bathrooms = get_post_meta( get_the_ID(), 'bathrooms', true );
                        $sq_feet = get_post_meta( get_the_ID(), 'sq_feet', true );
                        $status = get_post_meta( get_the_ID(), 'status', true );
                        ?>
                        <div class="property-card flex-shrink-0 w-full md:w-1/3 px-3">
                            <div class="bg-white rounded-2xl overflow-hidden shadow-lg">
                                <div class="relative">
                                    <?php if ( has_post_thumbnail() ) : ?>
                                        <?php the_post_thumbnail( 'large', array( 'class' => 'w-full h-64 object-cover object-top' ) ); ?>
                                    <?php else : ?>
                                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/property-placeholder.jpg' ); ?>" alt="<?php the_title_attribute(); ?>" class="w-full h-64 object-cover object-top">
                                    <?php endif; ?>
                                    
                                    <?php if ( $status ) : ?>
                                        <div class="absolute top-4 left-4 bg-primary text-white px-3 py-1 rounded-full text-sm font-semibold">
                                            <?php echo esc_html( $status ); ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <button class="absolute top-4 right-4 bg-white bg-opacity-90 p-2 rounded-full hover:bg-opacity-100 transition-all">
                                        <div class="w-5 h-5 flex items-center justify-center">
                                            <i class="ri-heart-line text-gray-600"></i>
                                        </div>
                                    </button>
                                </div>
                                <div class="p-6">
                                    <?php if ( $price ) : ?>
                                        <div class="text-3xl font-bold text-gray-900 mb-2">$<?php echo esc_html( number_format( $price ) ); ?></div>
                                    <?php endif; ?>
                                    
                                    <div class="text-gray-600 mb-4"><?php the_title(); ?></div>
                                    
                                    <div class="flex items-center space-x-6 text-sm text-gray-500 mb-6">
                                        <?php if ( $bedrooms ) : ?>
                                            <div class="flex items-center space-x-1">
                                                <div class="w-4 h-4 flex items-center justify-center">
                                                    <i class="ri-hotel-bed-line"></i>
                                                </div>
                                                <span><?php echo esc_html( $bedrooms ); ?> beds</span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if ( $bathrooms ) : ?>
                                            <div class="flex items-center space-x-1">
                                                <div class="w-4 h-4 flex items-center justify-center">
                                                    <i class="ri-drop-line"></i>
                                                </div>
                                                <span><?php echo esc_html( $bathrooms ); ?> baths</span>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if ( $sq_feet ) : ?>
                                            <div class="flex items-center space-x-1">
                                                <div class="w-4 h-4 flex items-center justify-center">
                                                    <i class="ri-aspect-ratio-line"></i>
                                                </div>
                                                <span><?php echo esc_html( number_format( $sq_feet ) ); ?> sq ft</span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <a href="<?php the_permalink(); ?>" class="w-full bg-gray-900 text-white py-3 rounded-lg hover:bg-gray-800 transition-colors font-semibold flex items-center justify-center space-x-2 whitespace-nowrap !rounded-button">
                                        <div class="w-4 h-4 flex items-center justify-center">
                                            <i class="ri-3d-view-line"></i>
                                        </div>
                                        <span>Virtual Tour</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php
                    endwhile;
                    wp_reset_postdata();
                else :
                    // Show default properties if no featured properties found
                    ?>
                    <div class="property-card flex-shrink-0 w-full md:w-1/3 px-3">
                        <div class="bg-white rounded-2xl overflow-hidden shadow-lg">
                            <div class="relative">
                                <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/property-1.jpg' ); ?>" alt="Luxury Colonial" class="w-full h-64 object-cover object-top">
                                <div class="absolute top-4 left-4 bg-primary text-white px-3 py-1 rounded-full text-sm font-semibold">Featured</div>
                                <button class="absolute top-4 right-4 bg-white bg-opacity-90 p-2 rounded-full hover:bg-opacity-100 transition-all">
                                    <div class="w-5 h-5 flex items-center justify-center">
                                        <i class="ri-heart-line text-gray-600"></i>
                                    </div>
                                </button>
                            </div>
                            <div class="p-6">
                                <div class="text-3xl font-bold text-gray-900 mb-2">$2,850,000</div>
                                <div class="text-gray-600 mb-4">Greenwich, Connecticut</div>
                                <div class="flex items-center space-x-6 text-sm text-gray-500 mb-6">
                                    <div class="flex items-center space-x-1">
                                        <div class="w-4 h-4 flex items-center justify-center">
                                            <i class="ri-hotel-bed-line"></i>
                                        </div>
                                        <span>5 beds</span>
                                    </div>
                                    <div class="flex items-center space-x-1">
                                        <div class="w-4 h-4 flex items-center justify-center">
                                            <i class="ri-drop-line"></i>
                                        </div>
                                        <span>4 baths</span>
                                    </div>
                                    <div class="flex items-center space-x-1">
                                        <div class="w-4 h-4 flex items-center justify-center">
                                            <i class="ri-aspect-ratio-line"></i>
                                        </div>
                                        <span>4,200 sq ft</span>
                                    </div>
                                </div>
                                <button class="w-full bg-gray-900 text-white py-3 rounded-lg hover:bg-gray-800 transition-colors font-semibold flex items-center justify-center space-x-2 whitespace-nowrap !rounded-button">
                                    <div class="w-4 h-4 flex items-center justify-center">
                                        <i class="ri-3d-view-line"></i>
                                    </div>
                                    <span>Virtual Tour</span>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            
            <button class="absolute left-4 top-1/2 transform -translate-y-1/2 bg-white shadow-lg p-3 rounded-full hover:bg-gray-50 transition-all" id="prevBtn">
                <div class="w-5 h-5 flex items-center justify-center">
                    <i class="ri-arrow-left-line text-gray-600"></i>
                </div>
            </button>
            <button class="absolute right-4 top-1/2 transform -translate-y-1/2 bg-white shadow-lg p-3 rounded-full hover:bg-gray-50 transition-all" id="nextBtn">
                <div class="w-5 h-5 flex items-center justify-center">
                    <i class="ri-arrow-right-line text-gray-600"></i>
                </div>
            </button>
            <div class="flex justify-center mt-8 space-x-2" id="sliderDots">
                <button class="w-3 h-3 rounded-full bg-primary"></button>
                <button class="w-3 h-3 rounded-full bg-gray-300"></button>
                <button class="w-3 h-3 rounded-full bg-gray-300"></button>
            </div>
        </div>
    </div>
</section>

<!-- Team Section -->
<section class="py-20 bg-gray-50" id="team">
    <div class="max-w-7xl mx-auto px-6">
        <div class="text-center mb-16">
            <h2 class="text-4xl md:text-5xl font-bold text-gray-900 mb-4">Meet Our Team</h2>
            <p class="text-xl text-gray-600">Expert agents dedicated to finding your perfect home</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php
            // Query agents
            $args = array(
                'post_type' => 'agent',
                'posts_per_page' => 3,
                'orderby' => 'menu_order',
                'order' => 'ASC'
            );
            
            $agents = new WP_Query( $args );
            
            if ( $agents->have_posts() ) :
                while ( $agents->have_posts() ) : $agents->the_post();
                    $specialty = get_post_meta( get_the_ID(), 'specialty', true );
                    ?>
                    <div class="agent-card relative overflow-hidden rounded-2xl shadow-lg group cursor-pointer">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <?php the_post_thumbnail( 'large', array( 'class' => 'w-full h-[500px] object-cover transition-transform duration-300 group-hover:scale-105' ) ); ?>
                        <?php else : ?>
                            <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/agent-placeholder.jpg' ); ?>" alt="<?php the_title_attribute(); ?>" class="w-full h-[500px] object-cover transition-transform duration-300 group-hover:scale-105">
                        <?php endif; ?>
                        
                        <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/70 to-transparent p-6 text-white">
                            <h3 class="text-xl font-bold mb-1"><?php the_title(); ?></h3>
                            <?php if ( $specialty ) : ?>
                                <p class="text-white/90"><?php echo esc_html( $specialty ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php
                endwhile;
                wp_reset_postdata();
            else :
                // Show default agents if no agents found
                ?>
                <div class="agent-card relative overflow-hidden rounded-2xl shadow-lg group cursor-pointer">
                    <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/agent-1.jpg' ); ?>" alt="Sarah Mitchell" class="w-full h-[500px] object-cover transition-transform duration-300 group-hover:scale-105">
                    <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/70 to-transparent p-6 text-white">
                        <h3 class="text-xl font-bold mb-1">Sarah Mitchell</h3>
                        <p class="text-white/90">Luxury Properties Specialist</p>
                    </div>
                </div>
                <div class="agent-card relative overflow-hidden rounded-2xl shadow-lg group cursor-pointer">
                    <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/agent-2.jpg' ); ?>" alt="Michael Chen" class="w-full h-[500px] object-cover transition-transform duration-300 group-hover:scale-105">
                    <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/70 to-transparent p-6 text-white">
                        <h3 class="text-xl font-bold mb-1">Michael Chen</h3>
                        <p class="text-white/90">Investment Properties Expert</p>
                    </div>
                </div>
                <div class="agent-card relative overflow-hidden rounded-2xl shadow-lg group cursor-pointer">
                    <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/agent-3.jpg' ); ?>" alt="Emma Rodriguez" class="w-full h-[500px] object-cover transition-transform duration-300 group-hover:scale-105">
                    <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/70 to-transparent p-6 text-white">
                        <h3 class="text-xl font-bold mb-1">Emma Rodriguez</h3>
                        <p class="text-white/90">First-Time Buyer Specialist</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Join Our Team Section -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-6">
        <div class="bg-gradient-to-r from-primary/10 to-secondary/10 rounded-2xl p-12 relative overflow-hidden">
            <div class="grid md:grid-cols-2 gap-12 items-center">
                <div class="relative z-10">
                    <h2 class="text-4xl font-bold text-gray-900 mb-4">
                        <?php echo esc_html( get_theme_mod( 'join_team_title', 'Join Our Growing Team' ) ); ?>
                    </h2>
                    <p class="text-xl text-gray-600 mb-8">
                        <?php echo esc_html( get_theme_mod( 'join_team_description', 'Take your real estate career to the next level with Elite Northeast Realty. We offer industry-leading support, training, and resources to help you succeed.' ) ); ?>
                    </p>
                    <ul class="space-y-4 mb-8">
                        <?php
                        $benefits_text = get_theme_mod( 'join_team_benefits', "Comprehensive training programs\nAdvanced marketing tools and support\nCompetitive commission structure\nAccess to exclusive luxury listings" );
                        $benefits = explode( "\n", $benefits_text );
                        
                        foreach ( $benefits as $benefit ) {
                            $benefit = trim( $benefit );
                            if ( ! empty( $benefit ) ) {
                                ?>
                                <li class="flex items-center space-x-3 text-gray-700">
                                    <div class="w-5 h-5 flex items-center justify-center text-primary">
                                        <i class="ri-check-line"></i>
                                    </div>
                                    <span><?php echo esc_html( $benefit ); ?></span>
                                </li>
                                <?php
                            }
                        }
                        ?>
                    </ul>
                    <a href="<?php echo esc_url( get_theme_mod( 'join_team_button_url', '#' ) ); ?>" class="bg-primary text-white px-8 py-4 rounded-lg hover:bg-blue-700 transition-colors font-semibold inline-flex items-center space-x-2 !rounded-button">
                        <span><?php echo esc_html( get_theme_mod( 'join_team_button_text', 'Start Your Career With Us' ) ); ?></span>
                        <div class="w-5 h-5 flex items-center justify-center">
                            <i class="ri-arrow-right-line"></i>
                        </div>
                    </a>
                </div>
                <div class="relative">
                    <?php
                    $join_image = get_theme_mod( 'join_team_image' );
                    if ( $join_image ) :
                        ?>
                        <img src="<?php echo esc_url( $join_image ); ?>" alt="Office Environment" class="rounded-xl shadow-2xl">
                    <?php else : ?>
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/office.jpg' ); ?>" alt="Office Environment" class="rounded-xl shadow-2xl">
                    <?php endif; ?>
                    
                    <div class="absolute -bottom-6 -right-6 bg-white rounded-2xl p-6 shadow-xl">
                        <div class="flex items-center space-x-4">
                            <div class="text-4xl font-bold text-primary">
                                <?php echo esc_html( get_theme_mod( 'join_team_stat_number', '95%' ) ); ?>
                            </div>
                            <div class="text-gray-600">
                                <?php echo esc_html( get_theme_mod( 'join_team_stat_text', 'Agent satisfaction rate' ) ); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Back to Top Button -->
<button class="back-to-top fixed bottom-8 right-8 bg-primary text-white p-3 rounded-full shadow-lg hover:bg-blue-700 transition-all z-40" id="backToTop">
    <div class="w-5 h-5 flex items-center justify-center">
        <i class="ri-arrow-up-line"></i>
    </div>
</button>

<?php
get_footer();
?>