<?php
/**
 * The template for displaying single property posts
 *
 * @package Elite_Northeast_Realty
 */

get_header();

while (have_posts()) :
    the_post();
    
    // Get property meta data
    $property_price = get_post_meta(get_the_ID(), 'property_price', true);
    $property_address = get_post_meta(get_the_ID(), 'property_address', true);
    $property_city = get_post_meta(get_the_ID(), 'property_city', true);
    $property_state = get_post_meta(get_the_ID(), 'property_state', true);
    $property_zip = get_post_meta(get_the_ID(), 'property_zip', true);
    $property_beds = get_post_meta(get_the_ID(), 'property_beds', true);
    $property_baths = get_post_meta(get_the_ID(), 'property_baths', true);
    $property_sqft = get_post_meta(get_the_ID(), 'property_sqft', true);
    
    // Check if ACF is available and use ACF fields if present
    if (function_exists('get_field')) {
        $price = get_field('price') ?: $property_price;
        $address = get_field('address') ?: $property_address;
        $city = get_field('city') ?: $property_city;
        $state = get_field('state') ?: $property_state;
        $zip = get_field('zip') ?: $property_zip;
        $beds = get_field('beds') ?: $property_beds;
        $baths = get_field('baths') ?: $property_baths;
        $sqft = get_field('sqft') ?: $property_sqft;
        $gallery_images = get_field('gallery_images');
        $special_features = get_field('special_features');
        $travel_times = get_field('travel_times');
        $interior_features = get_field('interior_features');
        $exterior_features = get_field('exterior_features');
        $neighborhood_description = get_field('neighborhood_description');
    } else {
        $price = $property_price;
        $address = $property_address;
        $city = $property_city;
        $state = $property_state;
        $zip = $property_zip;
        $beds = $property_beds;
        $baths = $property_baths;
        $sqft = $property_sqft;
        $gallery_images = get_post_meta(get_the_ID(), 'gallery_images', true);
        $special_features = get_post_meta(get_the_ID(), 'special_features', true);
        $travel_times = get_post_meta(get_the_ID(), 'travel_times', true);
        $interior_features = get_post_meta(get_the_ID(), 'interior_features', true);
        $exterior_features = get_post_meta(get_the_ID(), 'exterior_features', true);
        $neighborhood_description = get_post_meta(get_the_ID(), 'neighborhood_description', true);
    }
    
    // Format price
    $formatted_price = $price ? '$' . number_format($price) : 'Contact for Price';
    
    // Build full address
    $full_address = '';
    if ($address) $full_address .= $address;
    if ($city) $full_address .= ($full_address ? ', ' : '') . $city;
    if ($state) $full_address .= ($full_address ? ', ' : '') . $state;
    if ($zip) $full_address .= ' ' . $zip;
    ?>

    <main class="pt-20 min-h-screen">
        <div class="max-w-7xl mx-auto px-6 py-8">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Main Content Column -->
                <div class="lg:col-span-2">
                    <!-- Property Gallery -->
                    <div class="gallery-grid mb-8">
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="gallery-main">
                                <?php the_post_thumbnail('large', array('class' => 'w-full h-full object-cover rounded-lg', 'id' => 'mainImage')); ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($gallery_images && is_array($gallery_images)) : ?>
                            <?php $count = 0; ?>
                            <?php foreach ($gallery_images as $image) : ?>
                                <?php if ($count < 4) : ?>
                                    <div class="gallery-thumb">
                                        <img src="<?php echo esc_url($image['sizes']['medium']); ?>" 
                                             alt="<?php echo esc_attr($image['alt']); ?>" 
                                             class="w-full h-full object-cover rounded-lg gallery-thumb cursor-pointer" 
                                             onclick="changeMainImage('<?php echo esc_url($image['sizes']['large']); ?>')">
                                    </div>
                                <?php endif; ?>
                                <?php $count++; ?>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>

                    <!-- Property Details -->
                    <div class="bg-white rounded-lg shadow-sm p-6 mb-8">
                        <div class="flex items-center justify-between mb-4">
                            <h1 class="text-3xl font-bold text-gray-900"><?php echo esc_html($formatted_price); ?></h1>
                            <button class="w-10 h-10 flex items-center justify-center bg-gray-100 rounded-full hover:bg-gray-200 transition-colors">
                                <i class="ri-heart-line text-gray-600"></i>
                            </button>
                        </div>
                        
                        <?php if ($full_address) : ?>
                            <p class="text-gray-600 mb-4"><?php echo esc_html($full_address); ?></p>
                        <?php endif; ?>
                        
                        <div class="flex items-center space-x-8 text-gray-700 mb-6">
                            <?php if ($beds) : ?>
                                <div class="flex items-center space-x-2">
                                    <div class="w-5 h-5 flex items-center justify-center">
                                        <i class="ri-hotel-bed-line"></i>
                                    </div>
                                    <span class="font-medium"><?php echo esc_html($beds); ?> beds</span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($baths) : ?>
                                <div class="flex items-center space-x-2">
                                    <div class="w-5 h-5 flex items-center justify-center">
                                        <i class="ri-drop-line"></i>
                                    </div>
                                    <span class="font-medium"><?php echo esc_html($baths); ?> baths</span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($sqft) : ?>
                                <div class="flex items-center space-x-2">
                                    <div class="w-5 h-5 flex items-center justify-center">
                                        <i class="ri-aspect-ratio-line"></i>
                                    </div>
                                    <span class="font-medium"><?php echo number_format($sqft); ?> sqft</span>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="flex space-x-3">
                            <button class="flex-1 bg-primary text-white py-3 px-6 rounded-lg hover:bg-blue-700 transition-colors font-semibold !rounded-button whitespace-nowrap" onclick="openTourModal()">Request a tour</button>
                            <button class="flex-1 bg-gray-100 text-gray-900 py-3 px-6 rounded-lg hover:bg-gray-200 transition-colors font-semibold !rounded-button whitespace-nowrap" onclick="openContactModal()">Contact agent</button>
                        </div>
                    </div>

                    <!-- Special Features -->
                    <?php if ($special_features || get_the_content()) : ?>
                        <div class="bg-white rounded-lg shadow-sm p-6 mb-8">
                            <h2 class="text-xl font-bold text-gray-900 mb-4">What's special</h2>
                            
                            <?php if ($special_features && is_array($special_features)) : ?>
                                <div class="flex flex-wrap gap-2 mb-6">
                                    <?php foreach ($special_features as $feature) : ?>
                                        <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm font-medium">
                                            <?php echo esc_html($feature['feature']); ?>
                                        </span>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                            
                            <div class="text-gray-700 leading-relaxed prose max-w-none">
                                <?php the_content(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Travel Times -->
                    <?php if ($travel_times && is_array($travel_times)) : ?>
                        <div class="bg-white rounded-lg shadow-sm p-6 mb-8">
                            <h2 class="text-xl font-bold text-gray-900 mb-4">Travel times</h2>
                            <div class="space-y-3">
                                <?php foreach ($travel_times as $time) : ?>
                                    <div class="flex items-center justify-between">
                                        <span class="text-gray-700"><?php echo esc_html($time['destination']); ?></span>
                                        <span class="text-gray-900 font-medium"><?php echo esc_html($time['time']); ?></span>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Neighborhood -->
                    <div class="bg-white rounded-lg shadow-sm p-6 mb-8">
                        <h2 class="text-xl font-bold text-gray-900 mb-4">Neighborhood</h2>
                        <div class="w-full h-64 bg-gray-200 rounded-lg mb-4 relative overflow-hidden">
                            <div id="property-map" class="w-full h-full"></div>
                        </div>
                        <?php if ($neighborhood_description) : ?>
                            <p class="text-gray-700"><?php echo esc_html($neighborhood_description); ?></p>
                        <?php endif; ?>
                    </div>

                    <!-- Facts & Features -->
                    <?php if (($interior_features && is_array($interior_features)) || ($exterior_features && is_array($exterior_features))) : ?>
                        <div class="bg-white rounded-lg shadow-sm p-6">
                            <h2 class="text-xl font-bold text-gray-900 mb-6">Facts & features</h2>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <?php if ($interior_features && is_array($interior_features)) : ?>
                                    <div>
                                        <h3 class="font-semibold text-gray-900 mb-4">Interior</h3>
                                        <div class="space-y-3">
                                            <?php foreach ($interior_features as $feature) : ?>
                                                <div class="flex justify-between">
                                                    <span class="text-gray-600"><?php echo esc_html($feature['label']); ?></span>
                                                    <span class="text-gray-900"><?php echo esc_html($feature['value']); ?></span>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if ($exterior_features && is_array($exterior_features)) : ?>
                                    <div>
                                        <h3 class="font-semibold text-gray-900 mb-4">Exterior</h3>
                                        <div class="space-y-3">
                                            <?php foreach ($exterior_features as $feature) : ?>
                                                <div class="flex justify-between">
                                                    <span class="text-gray-600"><?php echo esc_html($feature['label']); ?></span>
                                                    <span class="text-gray-900"><?php echo esc_html($feature['value']); ?></span>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Sidebar -->
                <div class="lg:col-span-1">
                    <!-- Contact Form -->
                    <div class="bg-white rounded-lg shadow-sm p-6 mb-8">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">Contact Us</h3>
                        <div class="space-y-4">
                            <div class="grid grid-cols-2 gap-4">
                                <button class="w-full bg-primary text-white py-4 rounded-lg hover:bg-blue-700 transition-colors font-semibold !rounded-button whitespace-nowrap flex items-center justify-center space-x-2" onclick="openTourModal()">
                                    <i class="ri-calendar-line"></i>
                                    <span>Request Tour</span>
                                </button>
                                <button class="w-full bg-gray-100 text-gray-900 py-4 rounded-lg hover:bg-gray-200 transition-colors font-semibold !rounded-button whitespace-nowrap flex items-center justify-center space-x-2" onclick="openInfoModal()">
                                    <i class="ri-information-line"></i>
                                    <span>Request Info</span>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Tour with Agent -->
                    <div class="bg-white rounded-lg shadow-sm p-6 mb-8">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">Tour with a buyer's agent</h3>
                        <p class="text-gray-600 text-sm mb-4">We'll find a local agent to show you this home and help you navigate the buying process.</p>
                        <div class="flex items-center space-x-3 mb-4">
                            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                                <i class="ri-calendar-line text-blue-600"></i>
                            </div>
                            <div>
                                <p class="font-medium text-gray-900">Next available tour</p>
                                <p class="text-sm text-gray-600">Today at 12pm</p>
                            </div>
                        </div>
                        <button class="w-full bg-primary text-white py-3 rounded-lg hover:bg-blue-700 transition-colors font-semibold !rounded-button whitespace-nowrap" onclick="openTourModal()">Book tour with agent</button>
                    </div>

                    <!-- Pre-qualification Calculator -->
                    <div class="bg-white rounded-lg shadow-sm p-6 mb-8">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">Get pre-qualified</h3>
                        <p class="text-gray-600 text-sm mb-4">See what you can afford and get a competitive advantage when you make an offer.</p>
                        <form id="pre-qualification-form" class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Annual income</label>
                                <input type="text" name="income" placeholder="$75,000" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Down payment</label>
                                <input type="text" name="down_payment" placeholder="$50,000" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary text-sm">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Credit score</label>
                                <input type="range" name="credit_score" min="300" max="850" value="700" class="custom-range">
                                <div class="flex justify-between text-xs text-gray-500 mt-1">
                                    <span>300</span>
                                    <span id="credit-score-value">700</span>
                                    <span>850</span>
                                </div>
                            </div>
                            <button type="submit" class="w-full bg-gray-900 text-white py-3 rounded-lg hover:bg-gray-800 transition-colors font-semibold !rounded-button whitespace-nowrap">Calculate now</button>
                        </form>
                        <div id="qualification-result" class="mt-4 hidden"></div>
                    </div>

                    <!-- Get Pre-qualified CTA -->
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">Make this home a reality</h3>
                        <div class="flex items-center space-x-3 mb-4">
                            <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                                <i class="ri-shield-check-line text-green-600"></i>
                            </div>
                            <div>
                                <p class="font-medium text-gray-900">Get pre-qualified</p>
                                <p class="text-sm text-gray-600">Find out how much you can afford</p>
                            </div>
                        </div>
                        <button class="w-full bg-primary text-white py-3 rounded-lg hover:bg-blue-700 transition-colors font-semibold !rounded-button whitespace-nowrap" onclick="scrollToCalculator()">Get pre-qualified</button>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Contact Modals -->
    <div id="tourModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden flex items-center justify-center">
        <div class="bg-white rounded-lg p-6 max-w-md w-full mx-4">
            <h3 class="text-xl font-bold mb-4">Request a Tour</h3>
            <form id="tour-request-form" class="space-y-4">
                <input type="hidden" name="property_id" value="<?php echo get_the_ID(); ?>">
                <input type="hidden" name="property_title" value="<?php echo get_the_title(); ?>">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                    <input type="text" name="name" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                    <input type="email" name="email" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Phone</label>
                    <input type="tel" name="phone" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Preferred Date</label>
                    <input type="date" name="date" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Message (Optional)</label>
                    <textarea name="message" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary"></textarea>
                </div>
                <div class="flex space-x-3">
                    <button type="submit" class="flex-1 bg-primary text-white py-2 rounded-lg hover:bg-blue-700 transition-colors font-semibold">Send Request</button>
                    <button type="button" onclick="closeTourModal()" class="flex-1 bg-gray-200 text-gray-800 py-2 rounded-lg hover:bg-gray-300 transition-colors font-semibold">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <div id="contactModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden flex items-center justify-center">
        <div class="bg-white rounded-lg p-6 max-w-md w-full mx-4">
            <h3 class="text-xl font-bold mb-4">Contact Agent</h3>
            <form id="contact-agent-form" class="space-y-4">
                <input type="hidden" name="property_id" value="<?php echo get_the_ID(); ?>">
                <input type="hidden" name="property_title" value="<?php echo get_the_title(); ?>">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                    <input type="text" name="name" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                    <input type="email" name="email" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Phone</label>
                    <input type="tel" name="phone" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Message</label>
                    <textarea name="message" rows="4" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">I'm interested in learning more about this property at <?php echo esc_attr($full_address); ?>.</textarea>
                </div>
                <div class="flex space-x-3">
                    <button type="submit" class="flex-1 bg-primary text-white py-2 rounded-lg hover:bg-blue-700 transition-colors font-semibold">Send Message</button>
                    <button type="button" onclick="closeContactModal()" class="flex-1 bg-gray-200 text-gray-800 py-2 rounded-lg hover:bg-gray-300 transition-colors font-semibold">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <div id="infoModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden flex items-center justify-center">
        <div class="bg-white rounded-lg p-6 max-w-md w-full mx-4">
            <h3 class="text-xl font-bold mb-4">Request Information</h3>
            <form id="request-info-form" class="space-y-4">
                <input type="hidden" name="property_id" value="<?php echo get_the_ID(); ?>">
                <input type="hidden" name="property_title" value="<?php echo get_the_title(); ?>">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                    <input type="text" name="name" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                    <input type="email" name="email" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Phone</label>
                    <input type="tel" name="phone" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">What information would you like?</label>
                    <div class="space-y-2">
                        <label class="flex items-center">
                            <input type="checkbox" name="info_type[]" value="floor_plans" class="mr-2">
                            <span>Floor plans</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="info_type[]" value="hoa_details" class="mr-2">
                            <span>HOA details</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="info_type[]" value="utilities" class="mr-2">
                            <span>Utility information</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="info_type[]" value="schools" class="mr-2">
                            <span>School information</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" name="info_type[]" value="other" class="mr-2">
                            <span>Other (please specify)</span>
                        </label>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Additional Details</label>
                    <textarea name="message" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary"></textarea>
                </div>
                <div class="flex space-x-3">
                    <button type="submit" class="flex-1 bg-primary text-white py-2 rounded-lg hover:bg-blue-700 transition-colors font-semibold">Send Request</button>
                    <button type="button" onclick="closeInfoModal()" class="flex-1 bg-gray-200 text-gray-800 py-2 rounded-lg hover:bg-gray-300 transition-colors font-semibold">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <?php
endwhile;

get_footer();