<?php
/**
 * The sidebar containing the main widget area
 *
 * @package Elite_Northeast_Realty
 */

if ( ! is_active_sidebar( 'sidebar-1' ) && ! is_active_sidebar( 'sidebar-property' ) ) {
    return;
}
?>

<aside id="secondary" class="widget-area">
    <?php if ( is_singular( 'property' ) || is_post_type_archive( 'property' ) || is_tax( array( 'property_type', 'property_status' ) ) ) : ?>
        
        <?php if ( is_active_sidebar( 'sidebar-property' ) ) : ?>
            <?php dynamic_sidebar( 'sidebar-property' ); ?>
        <?php else : ?>
            <!-- Default Property Widgets -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h3 class="text-xl font-semibold text-gray-900 mb-4">Property Search</h3>
                <form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get" class="space-y-4">
                    <input type="hidden" name="post_type" value="property">
                    
                    <div>
                        <label for="property_type" class="block text-sm font-medium text-gray-700 mb-1">Property Type</label>
                        <select name="property_type" id="property_type" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-gold-500 focus:border-gold-500">
                            <option value="">All Types</option>
                            <?php
                            $property_types = get_terms( array(
                                'taxonomy' => 'property_type',
                                'hide_empty' => false,
                            ) );
                            
                            if ( ! is_wp_error( $property_types ) && ! empty( $property_types ) ) {
                                foreach ( $property_types as $type ) {
                                    echo '<option value="' . esc_attr( $type->slug ) . '">' . esc_html( $type->name ) . '</option>';
                                }
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div>
                        <label for="min_price" class="block text-sm font-medium text-gray-700 mb-1">Min Price</label>
                        <input type="number" name="min_price" id="min_price" placeholder="Min Price" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-gold-500 focus:border-gold-500">
                    </div>
                    
                    <div>
                        <label for="max_price" class="block text-sm font-medium text-gray-700 mb-1">Max Price</label>
                        <input type="number" name="max_price" id="max_price" placeholder="Max Price" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-gold-500 focus:border-gold-500">
                    </div>
                    
                    <div>
                        <label for="bedrooms" class="block text-sm font-medium text-gray-700 mb-1">Bedrooms</label>
                        <select name="bedrooms" id="bedrooms" class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-gold-500 focus:border-gold-500">
                            <option value="">Any</option>
                            <option value="1">1+</option>
                            <option value="2">2+</option>
                            <option value="3">3+</option>
                            <option value="4">4+</option>
                            <option value="5">5+</option>
                        </select>
                    </div>
                    
                    <button type="submit" class="w-full bg-gold-600 text-white py-2 px-4 rounded-md hover:bg-gold-700 transition duration-300">
                        Search Properties
                    </button>
                </form>
            </div>
            
            <!-- Contact Widget -->
            <div class="bg-navy-900 text-white rounded-lg shadow-md p-6 mb-6">
                <h3 class="text-xl font-semibold mb-4">Contact Us</h3>
                <div class="space-y-3">
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-gold-500 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                        </svg>
                        <div>
                            <p class="text-sm">Call Us</p>
                            <a href="tel:+1234567890" class="text-gold-500 hover:text-gold-400">(123) 456-7890</a>
                        </div>
                    </div>
                    
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-gold-500 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        <div>
                            <p class="text-sm">Email Us</p>
                            <a href="mailto:info@elitenortheastrealty.com" class="text-gold-500 hover:text-gold-400 break-all">info@elitenortheastrealty.com</a>
                        </div>
                    </div>
                    
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-gold-500 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        <div>
                            <p class="text-sm">Visit Us</p>
                            <p class="text-gold-500">123 Main Street<br>Boston, MA 02101</p>
                        </div>
                    </div>
                </div>
                
                <a href="<?php echo esc_url( home_url( '/contact' ) ); ?>" class="inline-block w-full text-center bg-gold-600 text-white py-2 px-4 rounded-md hover:bg-gold-700 transition duration-300 mt-6">
                    Schedule Consultation
                </a>
            </div>
            
            <!-- Recent Listings Widget -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h3 class="text-xl font-semibold text-gray-900 mb-4">Recent Listings</h3>
                <?php
                $recent_properties = new WP_Query( array(
                    'post_type' => 'property',
                    'posts_per_page' => 3,
                    'post_status' => 'publish',
                ) );
                
                if ( $recent_properties->have_posts() ) : ?>
                    <div class="space-y-4">
                        <?php while ( $recent_properties->have_posts() ) : $recent_properties->the_post(); ?>
                            <div class="border-b border-gray-200 pb-4 last:border-0 last:pb-0">
                                <a href="<?php the_permalink(); ?>" class="block group">
                                    <?php if ( has_post_thumbnail() ) : ?>
                                        <div class="aspect-w-16 aspect-h-9 mb-2 overflow-hidden rounded">
                                            <?php the_post_thumbnail( 'thumbnail', array( 'class' => 'w-full h-full object-cover group-hover:scale-105 transition duration-300' ) ); ?>
                                        </div>
                                    <?php endif; ?>
                                    <h4 class="font-semibold text-gray-900 group-hover:text-gold-600 transition duration-300">
                                        <?php the_title(); ?>
                                    </h4>
                                    <?php
                                    $price = get_post_meta( get_the_ID(), '_property_price', true );
                                    if ( $price ) : ?>
                                        <p class="text-gold-600 font-semibold"><?php echo esc_html( elite_format_price( $price ) ); ?></p>
                                    <?php endif; ?>
                                </a>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php else : ?>
                    <p class="text-gray-600">No properties found.</p>
                <?php endif;
                wp_reset_postdata();
                ?>
            </div>
        <?php endif; ?>
        
    <?php else : ?>
        
        <?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
            <?php dynamic_sidebar( 'sidebar-1' ); ?>
        <?php else : ?>
            <!-- Default Blog Widgets -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h3 class="text-xl font-semibold text-gray-900 mb-4">Search</h3>
                <?php get_search_form(); ?>
            </div>
            
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h3 class="text-xl font-semibold text-gray-900 mb-4">Recent Posts</h3>
                <ul class="space-y-2">
                    <?php
                    $recent_posts = wp_get_recent_posts( array(
                        'numberposts' => 5,
                        'post_status' => 'publish',
                    ) );
                    
                    foreach ( $recent_posts as $post ) : ?>
                        <li>
                            <a href="<?php echo get_permalink( $post['ID'] ); ?>" class="text-gray-700 hover:text-gold-600 transition duration-300">
                                <?php echo esc_html( $post['post_title'] ); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            
            <div class="bg-white rounded-lg shadow-md p-6">
                <h3 class="text-xl font-semibold text-gray-900 mb-4">Categories</h3>
                <ul class="space-y-2">
                    <?php
                    wp_list_categories( array(
                        'orderby' => 'name',
                        'title_li' => '',
                        'show_count' => true,
                        'echo' => true,
                        'hierarchical' => true,
                        'style' => 'list',
                        'hide_empty' => true,
                        'walker' => new Elite_Category_Walker(),
                    ) );
                    ?>
                </ul>
            </div>
        <?php endif; ?>
        
    <?php endif; ?>
</aside><!-- #secondary -->