    <footer class="bg-gray-900 text-white py-16">
        <div class="max-w-7xl mx-auto px-6">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <div>
                    <div class="font-['Pacifico'] text-2xl font-bold mb-4">
                        <a href="<?php echo esc_url(home_url('/')); ?>">
                            <?php bloginfo('name'); ?>
                        </a>
                    </div>
                    <p class="text-gray-400 mb-6">
                        <?php echo get_theme_mod('footer_tagline', 'Your trusted partner in finding the perfect Northeast property.'); ?>
                    </p>
                    <div class="flex space-x-4">
                        <?php if (get_theme_mod('facebook_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('facebook_url')); ?>" class="w-8 h-8 flex items-center justify-center bg-gray-800 rounded-full hover:bg-primary transition-colors" target="_blank" rel="noopener noreferrer">
                            <i class="ri-facebook-fill"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (get_theme_mod('twitter_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('twitter_url')); ?>" class="w-8 h-8 flex items-center justify-center bg-gray-800 rounded-full hover:bg-primary transition-colors" target="_blank" rel="noopener noreferrer">
                            <i class="ri-twitter-fill"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (get_theme_mod('instagram_url')) : ?>
                        <a href="<?php echo esc_url(get_theme_mod('instagram_url')); ?>" class="w-8 h-8 flex items-center justify-center bg-gray-800 rounded-full hover:bg-primary transition-colors" target="_blank" rel="noopener noreferrer">
                            <i class="ri-instagram-fill"></i>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div>
                    <h4 class="font-semibold mb-4">Properties</h4>
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-properties',
                        'container' => false,
                        'menu_class' => 'space-y-2 text-gray-400',
                        'fallback_cb' => 'elite_realty_footer_menu_fallback',
                        'depth' => 1,
                    ));
                    ?>
                </div>
                <div>
                    <h4 class="font-semibold mb-4">Company</h4>
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'footer-company',
                        'container' => false,
                        'menu_class' => 'space-y-2 text-gray-400',
                        'fallback_cb' => 'elite_realty_footer_menu_fallback',
                        'depth' => 1,
                    ));
                    ?>
                </div>
                <div>
                    <h4 class="font-semibold mb-4">Contact Info</h4>
                    <div class="space-y-3 text-gray-400">
                        <?php if (get_theme_mod('contact_phone')) : ?>
                        <div class="flex items-center space-x-3">
                            <div class="w-4 h-4 flex items-center justify-center">
                                <i class="ri-phone-line"></i>
                            </div>
                            <a href="tel:<?php echo esc_attr(get_theme_mod('contact_phone')); ?>" class="hover:text-white transition-colors">
                                <?php echo esc_html(get_theme_mod('contact_phone')); ?>
                            </a>
                        </div>
                        <?php endif; ?>
                        <?php if (get_theme_mod('contact_email')) : ?>
                        <div class="flex items-center space-x-3">
                            <div class="w-4 h-4 flex items-center justify-center">
                                <i class="ri-mail-line"></i>
                            </div>
                            <a href="mailto:<?php echo esc_attr(get_theme_mod('contact_email')); ?>" class="hover:text-white transition-colors">
                                <?php echo esc_html(get_theme_mod('contact_email')); ?>
                            </a>
                        </div>
                        <?php endif; ?>
                        <?php if (get_theme_mod('contact_address')) : ?>
                        <div class="flex items-center space-x-3">
                            <div class="w-4 h-4 flex items-center justify-center">
                                <i class="ri-map-pin-line"></i>
                            </div>
                            <span><?php echo esc_html(get_theme_mod('contact_address')); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="border-t border-gray-800 mt-12 pt-8 text-center text-gray-400">
                <p>&copy; <?php echo date('Y'); ?> <?php bloginfo('name'); ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>
    
    <button class="back-to-top fixed bottom-8 right-8 bg-primary text-white p-3 rounded-full shadow-lg hover:bg-blue-700 transition-all z-40" id="backToTop">
        <div class="w-5 h-5 flex items-center justify-center">
            <i class="ri-arrow-up-line"></i>
        </div>
    </button>
    
    <?php wp_footer(); ?>
</body>
</html>