/**
 * Navigation functionality for Elite Northeast Realty Theme
 */

(function() {
    'use strict';

    document.addEventListener('DOMContentLoaded', function() {
        // Navbar scroll functionality
        const navbar = document.querySelector('.navbar');
        const backToTop = document.getElementById('backToTop');
        
        if (navbar) {
            window.addEventListener('scroll', function() {
                if (window.scrollY > 100) {
                    navbar.classList.add('scrolled');
                    if (backToTop) {
                        backToTop.classList.add('visible');
                    }
                } else {
                    navbar.classList.remove('scrolled');
                    if (backToTop) {
                        backToTop.classList.remove('visible');
                    }
                }
            });
        }

        // Back to top button
        if (backToTop) {
            backToTop.addEventListener('click', function() {
                window.scrollTo({ top: 0, behavior: 'smooth' });
            });
        }

        // Mobile menu toggle
        const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
        const mobileMenu = document.querySelector('.mobile-menu');
        const mobileMenuClose = document.querySelector('.mobile-menu-close');

        if (mobileMenuToggle && mobileMenu) {
            mobileMenuToggle.addEventListener('click', function() {
                mobileMenu.classList.add('active');
                document.body.style.overflow = 'hidden';
            });
        }

        if (mobileMenuClose && mobileMenu) {
            mobileMenuClose.addEventListener('click', function() {
                mobileMenu.classList.remove('active');
                document.body.style.overflow = '';
            });
        }

        // Close mobile menu when clicking outside
        if (mobileMenu) {
            mobileMenu.addEventListener('click', function(e) {
                if (e.target === mobileMenu) {
                    mobileMenu.classList.remove('active');
                    document.body.style.overflow = '';
                }
            });
        }

        // Smooth scroll for anchor links
        const anchorLinks = document.querySelectorAll('a[href^="#"]');
        anchorLinks.forEach(function(link) {
            link.addEventListener('click', function(e) {
                const href = this.getAttribute('href');
                if (href !== '#' && href !== '#0') {
                    const target = document.querySelector(href);
                    if (target) {
                        e.preventDefault();
                        const offset = 100; // Account for fixed navbar
                        const targetPosition = target.offsetTop - offset;
                        window.scrollTo({
                            top: targetPosition,
                            behavior: 'smooth'
                        });
                    }
                }
            });
        });

        // Property slider functionality (if needed on other pages)
        const slider = document.getElementById('propertySlider');
        if (slider) {
            const prevBtn = document.getElementById('prevBtn');
            const nextBtn = document.getElementById('nextBtn');
            const dots = document.getElementById('sliderDots');
            let currentSlide = 0;
            const totalSlides = slider.children.length - 1;

            function updateSliderControls() {
                if (prevBtn && nextBtn) {
                    if (currentSlide === 0) {
                        prevBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    } else {
                        prevBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    }
                    
                    if (currentSlide === totalSlides) {
                        nextBtn.classList.add('opacity-50', 'cursor-not-allowed');
                    } else {
                        nextBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                    }
                }
            }

            function updateDots() {
                if (dots) {
                    const dotButtons = dots.getElementsByTagName('button');
                    Array.from(dotButtons).forEach((dot, index) => {
                        dot.classList.toggle('bg-primary', index === currentSlide);
                        dot.classList.toggle('bg-gray-300', index !== currentSlide);
                    });
                }
            }

            function updateSlider() {
                const offset = currentSlide * -100;
                slider.style.transform = `translateX(${offset}%)`;
                updateDots();
                updateSliderControls();
            }

            if (prevBtn) {
                prevBtn.addEventListener('click', () => {
                    if (currentSlide > 0) {
                        currentSlide--;
                        updateSlider();
                    }
                });
            }

            if (nextBtn) {
                nextBtn.addEventListener('click', () => {
                    if (currentSlide < totalSlides) {
                        currentSlide++;
                        updateSlider();
                    }
                });
            }

            if (dots) {
                const dotButtons = dots.getElementsByTagName('button');
                Array.from(dotButtons).forEach((dot, index) => {
                    dot.addEventListener('click', () => {
                        currentSlide = index;
                        updateSlider();
                    });
                });
            }

            // Touch support for slider
            let touchStartX = 0;
            let touchEndX = 0;

            slider.addEventListener('touchstart', (e) => {
                touchStartX = e.touches[0].clientX;
            }, false);

            slider.addEventListener('touchmove', (e) => {
                touchEndX = e.touches[0].clientX;
            }, false);

            slider.addEventListener('touchend', () => {
                const diffX = touchStartX - touchEndX;
                const sensitivity = 50;
                
                if (Math.abs(diffX) > sensitivity) {
                    if (diffX > 0 && currentSlide < totalSlides) {
                        currentSlide++;
                        updateSlider();
                    } else if (diffX < 0 && currentSlide > 0) {
                        currentSlide--;
                        updateSlider();
                    }
                }
            }, false);

            updateSlider();
        }
    });
})();